<?php
namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */

    protected $commands = [
        \App\Console\Commands\SendRecentPostsEmail::class, // ✅ Register here
        \App\Console\Commands\ExpireSmartAds::class,
        \App\Console\Commands\SendCustomPostNotifications::class,
    ];

    protected function schedule(Schedule $schedule)
    {
        $schedule->command('rss:fetch')->everyFifteenMinutes();
        $schedule->command('email:send-recent-posts')->everyFourHours();
        $schedule->command('posts:send-custom-notifications')->everySecond();
        $schedule->command('expired:plan')->daily();
        $schedule->command('ads:expire')->daily();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
